import React, {Component} from "react";

class HighLow extends Component{
    constructor(props) {
        super(props);
        this.state={
            rand:Math.floor(Math.random()*999)+1,
            mess:"This is where we'll tell you if your guess is too high or too low",
            guessCount:0,
            timer:90,
            guess:"",
            intervals:0,
            win:0,
            lose:0,
            
        }


        this.game=this.game.bind(this);
        this.updateInput=this.updateInput.bind(this);
        this.guessNum=this.guessNum.bind(this);
        this.timerTick=this.timerTick.bind(this);
        this.clearInput=this.clearInput.bind(this);
        
    };


clearInput(){
    this.setState({guess:""})
    this.refs.guess_field.focus();
}

resetTimer(){
    this.setState({
            rand:Math.floor(Math.random()*999)+1,
            mess:"This is where we'll tell you if your guess is too high or too low",
            guessCount:0,
            timer:90,
            guess:"",
            intervals:0,
    });
    clearInterval(this.intervals);
    
};

updateInput(e){
    this.setState({
        guess: e.target.value
    });
}

game(e){
    
    e.preventDefault();
    this.guessNum(e);

}

guessNum(){
    this.setState({
        guessCount:this.state.guessCount+1
    });
    if (this.state.timer===90){
        this.intervals=setInterval(this.timerTick, 1000)
    }else if(this.state.timer===0){
        this.setState({lose:this.state.lose+1});
        var ran=this.state.rand;
        window.alert("You lost! The number was "+ran+". Enter another number to restart the game!")
        this.resetTimer();
    }
    if (this.state.guess>this.state.rand){
        this.setState({
            mess:"Too high!"
        });
    } else if(this.state.guess<this.state.rand){
        this.setState({
            mess:"Too low!"
        })
    } else{
        this.setState({
            mess:"Correct!",
            win:this.state.win+1
        });
        var gc=this.state.guessCount+1;
        var ra=this.state.rand;
        window.alert("Correct! The number was "+ra+" and it took you "+gc+" guesses!");
        this.resetTimer();
    }
    this.clearInput();

}

timerTick(){
    this.setState({
        timer:this.state.timer-1
    });
    if (this.state.timer===0){
        this.guessNum();
    }
}


componentDidMount(){
console.log("componentDidMount: Component Mounted!")
}

componentWillUnmount(){
    console.log("componentWillUnmount: Component is unmounting!")
}

shouldComponentUpdate(){
    console.log("shouldComponentUpdate: Should component update?")
    if (this.state.guess!=="" || this.state.timer!==0){
        console.log("shouldComponentUpdate: Component should update!");
        return true;
    }else {
        console.log("shouldComponentUpdate: Component should not update");
        return false;
    }

};

componentDidUpdate(){
    console.log("componentDidUpdate: The Component Updated!");
    this.refs.guess_field.focus();
}




render(){
    return(
        
        <div>
           <h1>High Low Game</h1>
            <p>Welcome to the guessing game where you guess between the numbers 0 and 999. You only got 90 seconds to guess the number.
                Down below is where you'll see how many guesses you made. Inside the box is where you can make 
                your guesses and click the enter button or hit enter on your keyboard. Below that is where there 
                is message tell you if you number is too high or too low. Also there is a message that tell you the number of times 
                you lost and won. That is a wrap for now, happy guessing.
                 </p> 
            <p className="baseline">Guesses so far is <span className="base">{this.state.guessCount}</span></p>
            <form id="guessgame" onSubmit={this.game}>
                <input type="number" value={this.state.guess} onChange={this.updateInput}
                onFocus={e=>e.currentTarget.select()}
                ref="guess_field"
                ></input>
                <button type="submit">Enter</button>
            </form>
            <p className="baseline"><span className="base">{this.state.timer}</span> seconds left!</p> 
            <p className="baseline">{this.state.mess}</p>
            <p className="mainline">You've won <span className="main">{this.state.win}</span> times and lost <span className="main">{this.state.lose}</span> times!</p>
        </div>
    )
}
}


export default HighLow;
